
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <math.h>
#include <stdio.h>
#include <limits>
#include <bitset>

using namespace std;

map<int, int> isNumOccupied;
map<int, vector<int>> globalPossiblePlaces;
int globalN;
vector<int> result;

long long doStuff(int position) {
    if (position == globalN) {
        return 1;
    }

    
    long long r = 0;
    for (int num : globalPossiblePlaces[position]) {
        if (!isNumOccupied[num]) {
            isNumOccupied[num] = 1;
            result[position] = num;
            r += doStuff(position + 1);
            isNumOccupied[num] = 0;
            result[position] = -1;

        }
    }

    return r;
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;

    vector<int> result_(n);
    globalN = n;
    result = result_;

    vector<int> numbers(n);

    map<int, int> numOfNums;

    for (int i = 0; i < n; i++) {
        int a;
        cin >> a;
        numbers[i] = a;
        numOfNums[a]++;
    }

    vector<int> numsToN(n);

    for (int i = 0; i < n; i++) {
        numsToN[i] = i + 1;
    }

    sort(numsToN.begin(), numsToN.end(), [&](const int a, const int b) {
        return numOfNums[a] > numOfNums[b];
        });

    map<int, vector<int>> possiblePlaces;

    map<int, int> reservedPlaces;

    if (numOfNums[numsToN[0]] > 3) {
        printf("0");
        return 0;
    }

    for (int num : numsToN) {
        int index = find(numbers.begin(), numbers.end(), num) - numbers.begin();
        if (numOfNums[num] == 3) { 
            if (numbers[index] == numbers[index + 1] && numbers[index + 1] == numbers[index + 2]) {
                possiblePlaces[index + 1] = {num};
                reservedPlaces[index + 1] = 1;
            }
            else {
                printf("0");
                return 0;
            }
        }
        else if (numOfNums[num] == 2) {
            if (numbers[index] == numbers[index + 1]) {
                possiblePlaces[index].push_back(num);
                possiblePlaces[index + 1].push_back(num);
            }
            else if (numbers[index] == numbers[index + 2]) {
                possiblePlaces[index + 1] = { num };
                reservedPlaces[index + 1] = 1;
            }
            else {
                printf("0");
                return 0;
            }
        }
        else if (numOfNums[num] == 1) {
            if (reservedPlaces[index] && reservedPlaces[index - 1] && reservedPlaces[index + 1]) {
                printf("0");
                return 0;
            }
            if (index != 0 && !reservedPlaces[index - 1]) {
                possiblePlaces[index - 1].push_back(num);
            }
            if (!reservedPlaces[index]) {
                possiblePlaces[index].push_back(num);
            }
            if (index != n - 1 && !reservedPlaces[index + 1]) {
                possiblePlaces[index + 1].push_back(num);
            }
        }
        else {
            for (int i = 0; i < n; i++) {
                if (!reservedPlaces[i]) {
                    possiblePlaces[i].push_back(num);
                }
            }
        }
    }

    globalPossiblePlaces = possiblePlaces;

    long long result = doStuff(0);

    printf("%lld", result);
   
}
